package w83a.xml.parser;

import java.io.Serializable;
import java.text.ParseException;
//import java.util.logging.Logger;

import w83a.w83aUtilidadesComunes.W83ALocaleString;
import w83a.w83aUtilidadesComunes.W83ALocaleStringXML;
import w83a.w83aUtilidadesComunes.W83AUtilXml;
import w83a.w83aUtilidadesComunes.W83aException;
import w83a.xml.W83AXmlDocument;
import w83a.xml.W83AXmlElement;
import w83a.xml.datatype.W83AConsultationContext;
import w83a.xml.exception.W83AXmlException;



public class W83AConsultationContextParser implements Serializable {

	private static final long serialVersionUID = 1L;

	public W83AConsultationContextParser(String xmlConstultationContext)
			throws W83AXmlException, W83aException, ParseException {
		xmlDocument = new W83AXmlDocument();
		try {
			xmlDocument.createFromUtf8StringText(xmlConstultationContext);
		} catch (Exception e) {
			xmlDocument.createFromStringText(xmlConstultationContext);
		}
	}

	public W83AConsultationContextParser() {

	}

	public W83AConsultationContext getProcedureData() throws W83aException,
			W83AXmlException, ParseException {
		W83AXmlElement root = xmlDocument.getRootElement();
/*		W83AXmlElement elemento;
		W83AXmlElement subElemento;
		String sAux;*/

		//W83AXmlElement elementoValidation =
		// root.getChildElement("Procedure");
//		String familyID = W83AUtilXml.getStringValue(root, "familyId");
		String procedureName = root.getXmlElement("procedureName/description")
				.getStringText(true);
		W83ALocaleString procedureNameLocale = null;
		if (procedureName != null && !procedureName.equals(""))
		{	procedureNameLocale = W83ALocaleStringXML
					.getLocaleString(procedureName);}
		String departmentId = W83AUtilXml.getStringValue(root, "departmentId");
		String departmentName = root
				.getXmlElement("departmentName/description")
				.getStringText(true);
		W83ALocaleString departmentNameLocale = W83ALocaleStringXML
				.getLocaleString(departmentName);
		String managingUnitId = W83AUtilXml.getStringValue(root,
				"organInfo/managingUnitId");
		String managingUnitName = root.getXmlElement(
				"organInfo/managingUnitName/description").getStringText(true);
		W83ALocaleString managingUnitNameLocale = null;
		if (managingUnitName != null && !managingUnitName.equals(""))
		{	managingUnitNameLocale = W83ALocaleStringXML
					.getLocaleString(managingUnitName);}
		String familyName = root.getXmlElement("familyName/description")
				.getStringText(true);
		;
		W83ALocaleString familyNameLocale = null;
		if (familyName != null && !familyName.equals(""))
		{	familyNameLocale = W83ALocaleStringXML.getLocaleString(familyName);}

		procedureCtx = new W83AConsultationContext(familyNameLocale,
				managingUnitId, departmentId, procedureNameLocale,
				departmentNameLocale, managingUnitNameLocale);
		return procedureCtx;
	}

	public W83AConsultationContext getProcedureDataAll() throws W83aException,
			W83AXmlException, ParseException {

		W83AXmlElement root = xmlDocument.getRootElement();
	/*	W83AXmlElement elemento;
		W83AXmlElement subElemento;
		String sAux;*/

		//W83AXmlElement elementoValidation = root.getChildElement("Procedure");
		String procedureId = W83AUtilXml.getStringValue(root,
				"procedureId");
		
		/*String procedureName = W83AUtilXml.getStringValue(root,
		"procedureName/description");*/

		String procedureName = root.getXmlElement(
				"procedureName/description").getStringText(true);
		W83ALocaleString procedureNameLocale = null;
		if (procedureName != null && !procedureName.equals(""))
			procedureNameLocale = W83ALocaleStringXML
					.getLocaleString(procedureName);

		
		
		String departmentId = W83AUtilXml.getStringValue(root,
				"departmentId");
		String departmentName = root.getXmlElement(
				"departmentName/description").getStringText(true);
		W83ALocaleString departmentNameLocale = null;
		if (departmentName != null && !departmentName.equals(""))
		{	departmentNameLocale = W83ALocaleStringXML
					.getLocaleString(departmentName);}

		String entityCode = W83AUtilXml.getStringValue(root,
				"entityCode");

		String managingUnitId = W83AUtilXml.getStringValue(root,
		"managingUnitId");
		/*String managingUnitFunction = W83AUtilXml.getStringValue(
				elementoValidation, "managingUnitFunction");
		String managingUnitDeliveryKeyFunction = W83AUtilXml.getStringValue(
				elementoValidation, "managingUnitDeliveryKeyFunction");
*/
		String managingUnitName = root.getXmlElement(
				"managingUnitName/description").getStringText(true);
		W83ALocaleString managingUnitNameLocale = null;
		if (managingUnitName != null && !managingUnitName.equals(""))
		{	managingUnitNameLocale = W83ALocaleStringXML
					.getLocaleString(managingUnitName);}
/*
		String familyID = W83AUtilXml.getStringValue(elementoValidation,
				"FamilyId");

		String procedureInboxID = W83AUtilXml.getStringValue(
				elementoValidation, "ProcedureInboxId");
		String procedureInboxName = W83AUtilXml.getStringValue(
				elementoValidation, "ProcedureInboxName ");

		String certifiedValidationMode = W83AUtilXml.getStringValue(
				elementoValidation, "certifiedValidationMode");
		String telematicsCode = W83AUtilXml.getStringValue(elementoValidation,
				"telematicscode");
		String managingUnitInBoxID = W83AUtilXml.getStringValue(
				elementoValidation, "managingUnitInboxId");

		//20Septiembre
		W83AXmlElement telematicElement = root
				.getChildElement("TelematicAction");
		String telematicActionId = W83AUtilXml.getStringValue(telematicElement,
				"telematicActionId");
		String telematicActionName = telematicElement.getXmlElement(
				"telematicActionName/description").getStringText(true);
		W83ALocaleString telematicActionNameLocale = W83ALocaleStringXML
				.getLocaleString(telematicActionName);
		*/
		//adaptacion platea v2.1
		W83AXmlElement documentalSerieElement = null;
		String documentalSerie01Id = "";
		String documentalSerie20Id = "";
		String documentalSerie48Id = "";
		
		if(root.getChildElement("daDocumentalSeries01")!=null){
			documentalSerieElement=	root.getChildElement("daDocumentalSeries01");
			documentalSerie01Id=W83AUtilXml.getStringValue(documentalSerieElement,"ID");
		}
		if(root.getChildElement("daDocumentalSeries20")!=null){
			documentalSerieElement = root.getChildElement("daDocumentalSeries20");
			documentalSerie20Id=W83AUtilXml.getStringValue(documentalSerieElement,"ID");
		}
		if(root.getChildElement("daDocumentalSeries48")!=null){
			documentalSerieElement = root.getChildElement("daDocumentalSeries48");
			documentalSerie48Id=W83AUtilXml.getStringValue(documentalSerieElement,"ID");	
		}
		
		String daProcedureId = W83AUtilXml.getStringValue(root,
		"daProcedureID");
		
		procedureCtx = new W83AConsultationContext(procedureId,
				procedureNameLocale, entityCode, departmentId,
				departmentNameLocale, managingUnitId, managingUnitNameLocale,
				/*managingUnitFunction, managingUnitDeliveryKeyFunction,
				familyID, procedureInboxID, procedureInboxName,
				certifiedValidationMode, telematicsCode, entityNameLocale,
				managingUnitInBoxID, telematicActionId,
				telematicActionNameLocale, */
				documentalSerie01Id, documentalSerie20Id, documentalSerie48Id,daProcedureId);

		return procedureCtx;
	}

	//private R02DProcedure procedure;
	private W83AConsultationContext procedureCtx;

	private W83AXmlDocument xmlDocument;

//	private static Logger log = Logger
//			.getLogger(W83AConsultationContextParser.class.getName());
}